Public Class frmPictureTest
  Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Friend WithEvents PictureBox1 As System.Windows.Forms.PictureBox
  Friend WithEvents btnOpen As System.Windows.Forms.Button
  Friend WithEvents btnExit As System.Windows.Forms.Button
  Friend WithEvents lblSize As System.Windows.Forms.Label
  Friend WithEvents OpenFileDialog1 As System.Windows.Forms.OpenFileDialog
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.PictureBox1 = New System.Windows.Forms.PictureBox()
    Me.btnOpen = New System.Windows.Forms.Button()
    Me.btnExit = New System.Windows.Forms.Button()
    Me.lblSize = New System.Windows.Forms.Label()
    Me.OpenFileDialog1 = New System.Windows.Forms.OpenFileDialog()
    Me.SuspendLayout()
    '
    'PictureBox1
    '
    Me.PictureBox1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.PictureBox1.Location = New System.Drawing.Point(8, 8)
    Me.PictureBox1.Name = "PictureBox1"
    Me.PictureBox1.Size = New System.Drawing.Size(416, 272)
    Me.PictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
    Me.PictureBox1.TabIndex = 0
    Me.PictureBox1.TabStop = False
    '
    'btnOpen
    '
    Me.btnOpen.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.btnOpen.Location = New System.Drawing.Point(8, 336)
    Me.btnOpen.Name = "btnOpen"
    Me.btnOpen.Size = New System.Drawing.Size(136, 24)
    Me.btnOpen.TabIndex = 1
    Me.btnOpen.Text = "&File Open"
    '
    'btnExit
    '
    Me.btnExit.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.btnExit.Location = New System.Drawing.Point(288, 336)
    Me.btnExit.Name = "btnExit"
    Me.btnExit.Size = New System.Drawing.Size(136, 24)
    Me.btnExit.TabIndex = 2
    Me.btnExit.Text = "E&xit"
    '
    'lblSize
    '
    Me.lblSize.Location = New System.Drawing.Point(152, 336)
    Me.lblSize.Name = "lblSize"
    Me.lblSize.Size = New System.Drawing.Size(128, 24)
    Me.lblSize.TabIndex = 3
    Me.lblSize.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
    '
    'frmPictureTest
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(440, 365)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.lblSize, Me.btnExit, Me.btnOpen, Me.PictureBox1})
    Me.Name = "frmPictureTest"
    Me.Text = "View a Graphics Image"
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Sub btnOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOpen.Click
    Dim path As String
    Static InitialSize As Size = PictureBox1.Size ' Save original control size

    PictureBox1.Size = InitialSize                ' Reset the control size

    With OpenFileDialog1                          ' Initialize the file dialog
      .Filter = "Bitmap (*.BMP)|*.bmp |Icon (*.ICO)|*.ICO|GIF (*.GIF)|*.GIF|Metafile (*.WMF)|*.WMF|JPEG (*.JPG)|*.JPG"
      .FilterIndex = 5
      .InitialDirectory = "C:\"
      .Title = "Select Image File"
    End With

    If OpenFileDialog1.ShowDialog() = DialogResult.OK Then  ' See if file selected
      path = OpenFileDialog1.FileName
      Me.Text = "View a Graphics Image   " & path
      CalculateControlSize(path)
    End If

  End Sub

  Private Sub CalculateControlSize(ByVal path As String)
    Dim OriginalX, OriginalY As Integer
    Dim NewSize As Size
    Dim Aspect As Double
    Dim pic As Image = Image.FromFile(path)

    OriginalX = PictureBox1.Size.Width     ' Original control size
    OriginalY = PictureBox1.Size.Height

    lblSize.Text = "(" & CStr(pic.Width) & "x" & CStr(pic.Height) & ")"
    Aspect = CDbl(pic.Height) / CDbl(pic.Width)   ' Find the aspect ratio

    If Aspect < 1.0 Then                    ' If height less than width
      NewSize.Height = CInt(Aspect * OriginalX)
      NewSize.Width = OriginalX
      PictureBox1.Size = NewSize
    Else                                    ' width less than height
      NewSize.Width = CInt(OriginalY / Aspect)
      NewSize.Height = OriginalY
      PictureBox1.Size = NewSize
    End If

    ' Force image to fit the control
    PictureBox1.SizeMode = PictureBoxSizeMode.StretchImage
    ' Load the picture into the control.
    PictureBox1.Image = Image.FromFile(path)

  End Sub


  Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
    Me.Dispose()
  End Sub
End Class
